<?php
/**
 * Transfer Ruud
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('transferruud_title',true).'</span></div>';

try {
	
	$TransferRuud = new Plugin\TransferRuud\TransferRuud();
	$TransferRuud->setUser($_SESSION['username']);
	$playerList = $TransferRuud->getAccountPlayerListRuud();
	if(!is_array($playerList)) throw new Exception(lang('transferruud_error_11'));
	
	if(check_value($_GET['success'])) {
		message('success', lang('transferruud_success_1',true));
	}
	
	if(!check_value($_GET['player']) && !check_value($_GET['type']) && !check_value($_GET['credits'])) {
		
		// Form Submit
		if(check_value($_POST['transfer_submit'])) {
			try {
				
				if(!check_value($_POST['player_name'])) throw new Exception(lang('transferruud_error_5',true));
				if(!Validator::AlphaNumeric($_POST['player_name'])) throw new Exception(lang('transferruud_error_5',true));
				
				if(!check_value($_POST['ruud_character'])) throw new Exception(lang('transferruud_error_6',true));
				if($_POST['ruud_character'] == '0') throw new Exception(lang('transferruud_error_6',true));
				
				if(!check_value($_POST['ruud_amount'])) throw new Exception(lang('transferruud_error_7',true));
				if(!Validator::UnsignedNumber($_POST['ruud_amount'])) throw new Exception(lang('transferruud_error_7',true));
				
				redirect(1, 'ruud/transfer/player/'.$_POST['player_name'].'/character/'.$_POST['ruud_character'].'/amount/'.$_POST['ruud_amount'].'/');
				
			} catch(Exception $ex) {
				message('error', $ex->getMessage());
			}
		}
		
		// Transfer Form
		echo '<div class="col-xs-8 col-xs-offset-2" style="margin-top:30px;">';
			echo '<form class="form-horizontal" action="" method="post">';
			
				echo '<div class="form-group">';
					echo '<label for="input1">'.lang('transferruud_txt_4',true).'</label>';
					echo '<input type="text" name="player_name" class="form-control" id="input1">';
				echo '</div>';
				
				echo '<div class="form-group">';
					echo '<label for="input2">'.lang('transferruud_txt_5',true).'</label>';
					echo '<select name="ruud_character" class="form-control" id="input2">';
						echo '<option value="0">'.lang('transferruud_txt_2',true).'</option>';
						foreach($playerList as $playerName => $playerRuud) {
							echo '<option value="'.$playerName.'">'.langf('transferruud_txt_9', array($playerName, $playerRuud)).'</option>';
						}
					echo '</select>';
				echo '</div>';
				
				echo '<div class="form-group">';
					echo '<label for="input3">'.lang('transferruud_txt_6',true).'</label>';
					echo '<input type="text" name="ruud_amount" class="form-control" id="input3">';
				echo '</div>';
				
				
				echo '<div class="form-group">';
					echo '<button type="submit" name="transfer_submit" value="submit" class="btn btn-primary pull-right">'.lang('transferruud_txt_1',true).'</button>';
				echo '</div>';
			echo '</form>';
		echo '</div>';
		
	} else {
		
		// Transfer Confirmation
		
		// player
		$playerName = $_GET['player'];
		
		// credits type
		$characterName = $_GET['character'];
		
		// amount
		$ruudAmount = $_GET['amount'];
		$TransferRuud->setTransferAmount($ruudAmount);
		
		// tax
		$transferTax = $TransferRuud->getTransferTaxValue();
		
		// total
		$ruudTotal = $TransferRuud->calculateTransferTotal();
		
		// CONFIRM TRANSFER
		if(check_value($_GET['confirm'])) {
			try {
				
				$TransferRuud->setPlayer($playerName);
				$TransferRuud->setSenderPlayer($characterName);
				$TransferRuud->transfer();
				
			} catch(Exception $ex) {
				message('error', $ex->getMessage());
			}
		}
		
		echo '<div class="col-xs-8 col-xs-offset-2" style="margin-top:30px;">';
			echo '<table class="table table-bordered table-hover table-striped">';
				echo '<tr>';
					echo '<th class="text-right" style="width:35%;">'.lang('transferruud_txt_4',true).'</th>';
					echo '<td class="text-right">'.$playerName.'</td>';
				echo '</tr>';
				echo '<tr>';
					echo '<th class="text-right">'.lang('transferruud_txt_5',true).'</th>';
					echo '<td class="text-right">'.$characterName.'</td>';
				echo '</tr>';
				echo '<tr>';
					echo '<th class="text-right">'.lang('transferruud_txt_6',true).'</th>';
					echo '<td class="text-right">'.number_format($ruudAmount).' '.lang('transferruud_txt_10').'</td>';
				echo '</tr>';
				echo '<tr>';
					echo '<th class="text-right">'.lang('transferruud_txt_7',true).'</th>';
					echo '<td class="text-right">'.number_format($transferTax).'%</td>';
				echo '</tr>';
				echo '<tr>';
					echo '<th class="text-right" style="color:red;">'.lang('transferruud_txt_8',true).'</th>';
					echo '<td class="text-right" style="color:red;">'.number_format($ruudTotal).' '.lang('transferruud_txt_10').'</td>';
				echo '</tr>';
			echo '</table>';
			
			echo '<a href="'.__BASE_URL__.'ruud/transfer/player/'.$playerName.'/character/'.$characterName.'/amount/'.$ruudAmount.'/confirm/1" class="btn btn-primary pull-right">'.lang('transferruud_txt_3',true).'</a>';
			echo '<a href="'.__BASE_URL__.'ruud/transfer/" class="btn btn-primary pull-right" style="margin-right:5px;">'.lang('transferruud_txt_11',true).'</a>';
		echo '</div>';
		
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}